**************************************************
*-- Class Library:  o:\usr\kozos\adatb.3\samples\controls\buttons.vcx
**************************************************





**************************************************
*-- Class:        cmdhelp (o:\usr\kozos\adatb.3\samples\controls\buttons.vcx)
*-- ParentClass:  commandbutton
*-- BaseClass:    commandbutton
*-- Brings up the help file, searching for the HelpContextID of the control
*
DEFINE CLASS cmdhelp AS commandbutton


	Caption = "\<Help"
	Height = 30
	Width = 94
	HelpContextID = 15
	Name = "cmdHelp"


	PROCEDURE Click
		HELP ID This.HelpContextID
	ENDPROC


ENDDEFINE
*
*-- EndDefine: cmdhelp
**************************************************





**************************************************
*-- Class:        cmdok (o:\usr\kozos\adatb.3\samples\controls\buttons.vcx)
*-- ParentClass:  commandbutton
*-- BaseClass:    commandbutton
*-- RELEASE THISFORM, default button
*
DEFINE CLASS cmdok AS commandbutton


	Height = 30
	Width = 94
	Caption = "OK"
	Default = .F.
	Name = "cmdok"


	PROCEDURE Click
		IF TYPE("THISFORM.PARENT") = 'O'
			RELEASE THISFORMSET
		ELSE
			RELEASE THISFORM
		ENDIF
	ENDPROC


ENDDEFINE
*
*-- EndDefine: cmdok
**************************************************





**************************************************
*-- Class:        cmdcancel (o:\usr\kozos\adatb.3\samples\controls\buttons.vcx)
*-- ParentClass:  cmdok (o:\usr\kozos\adatb.3\samples\controls\buttons.vcx)
*-- BaseClass:    commandbutton
*-- Release Form or Form Set
*
DEFINE CLASS cmdcancel AS cmdok


	Caption = "Cancel"
	Name = "cmdCancel"


ENDDEFINE
*
*-- EndDefine: cmdcancel
**************************************************





**************************************************
*-- Class:        vcr (o:\usr\kozos\adatb.3\samples\controls\buttons.vcx)
*-- ParentClass:  container
*-- BaseClass:    container
*-- generic vcr buttons
*
DEFINE CLASS vcr AS container


	Width = 181
	Height = 25
	BackColor = RGB(192,192,192)
	BorderWidth = 1
	*-- The table to move the record pointer in .
	skiptable = ""
	Name = "vcr"


	ADD OBJECT cmdtop AS commandbutton WITH ;
		Top = 0, ;
		Left = 0, ;
		Height = 25, ;
		Width = 37, ;
		Caption = "|<", ;
		TabIndex = 1, ;
		Name = "cmdTop"


	ADD OBJECT cmdprior AS commandbutton WITH ;
		Top = 0, ;
		Left = 48, ;
		Height = 25, ;
		Width = 37, ;
		Caption = "<", ;
		TabIndex = 2, ;
		Name = "cmdPrior"


	ADD OBJECT cmdnext AS commandbutton WITH ;
		Top = 0, ;
		Left = 96, ;
		Height = 25, ;
		Width = 37, ;
		Caption = ">", ;
		TabIndex = 3, ;
		Name = "cmdNext"


	ADD OBJECT cmdbottom AS commandbutton WITH ;
		Top = 0, ;
		Left = 144, ;
		Height = 25, ;
		Width = 37, ;
		Caption = ">|", ;
		TabIndex = 4, ;
		Name = "cmdBottom"


	PROCEDURE Error
		Parameters nError, cMethod, nLine
		#define NUM_LOC "Error Number: "
		#define PROG_LOC "Procedure: "
		#define MSG_LOC "Error Message: "
		#define CR_LOC CHR(13)
		#define SELTABLE_LOC "Select Table:"
		#define OPEN_LOC "Open"
		* If the user tries to move the record pointer when no
		* table is open or when an invalid SkipTable property has bee
		* specified, prompt the user for a table to open.

		DO CASE
			CASE nError = 13 && Alias not found
				cNewTable = GETFILE('DBF', SELTABLE_LOC, OPEN_LOC)
				IF FILE(cNewTable)
					SELECT 0
					USE (cNewTable)
					This.SkipTable = ALIAS()
				ELSE
					This.SkipTable = ""
				ENDIF
			OTHERWISE
				lcMsg = NUM_LOC + ALLTRIM(STR(nError)) + CR_LOC + CR_LOC + ;
						MSG_LOC + MESSAGE( )+ CR_LOC + CR_LOC + ;
						PROG_LOC + PROGRAM(1)
				lnAnswer = MESSAGEBOX(lcMsg, 2+48+512)
				DO CASE
					CASE lnAnswer = 3 &&Abort
						CANCEL
					CASE lnAnswer = 4 &&Retry
						RETRY
					OTHERWISE
						RETURN
				ENDCASE
		ENDCASE
	ENDPROC


	PROCEDURE cmdtop.Error
		Parameters nError, cMethod, nLine
		This.Parent.Error(nError, cMethod, nLine)
	ENDPROC


	PROCEDURE cmdtop.Click
		IF !EMPTY(This.Parent.SkipTable)
			SELECT (This.Parent.SkipTable)
		ENDIF
		GO TOP
		This.Enabled = .F.
		This.Parent.cmdPrior.Enabled = .F.
		This.Parent.cmdBottom.Enabled = .T.
		This.Parent.cmdNext.Enabled = .T.
		THISFORM.Refresh
	ENDPROC


	PROCEDURE cmdprior.Error
		Parameters nError, cMethod, nLine
		This.Parent.Error(nError, cMethod, nLine)
	ENDPROC


	PROCEDURE cmdprior.Click
		IF !EMPTY(This.Parent.SkipTable)
			SELECT (This.Parent.SkipTable)
		ENDIF
		SKIP -1
		IF BOF()
			GO TOP
			This.Enabled = .F.
			This.Parent.cmdTop.Enabled = .F.
		ELSE
			This.Parent.SETALL("Enabled", .T., "Commandbutton")
		ENDIF
		THISFORM.Refresh
	ENDPROC


	PROCEDURE cmdnext.Error
		Parameters nError, cMethod, nLine
		This.Parent.Error(nError, cMethod, nLine)
	ENDPROC


	PROCEDURE cmdnext.Click
		IF !EMPTY(This.Parent.SkipTable)
			SELECT (This.Parent.SkipTable)
		ENDIF
		SKIP 1
		IF EOF()
			GO BOTTOM
			This.Enabled = .F.
			This.Parent.cmdBottom.Enabled = .F.
		ELSE
			This.Parent.SETALL("Enabled", .T., "Commandbutton")
		ENDIF
		THISFORM.Refresh
	ENDPROC


	PROCEDURE cmdbottom.Error
		Parameters nError, cMethod, nLine
		This.Parent.Error(nError, cMethod, nLine)
	ENDPROC


	PROCEDURE cmdbottom.Click
		IF !EMPTY(This.Parent.SkipTable)
			SELECT (This.Parent.SkipTable)
		ENDIF
		GO BOTTOM
		This.Enabled = .F.
		This.Parent.cmdNext.Enabled = .F.
		This.Parent.cmdTop.Enabled = .T.
		This.Parent.cmdPrior.Enabled = .T.
		THISFORM.Refresh
	ENDPROC


ENDDEFINE
*
*-- EndDefine: vcr
**************************************************
